/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.lootcrates.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.lootcrates.LootCrateAtlas;
import de.dafuqs.lootcrates.components.InventoryDeletionMode;
import de.dafuqs.lootcrates.components.LockMode;
import de.dafuqs.lootcrates.components.PlayerCrateData;
import de.dafuqs.lootcrates.components.ReplenishTimeScale;
import de.dafuqs.lootcrates.enums.LootCrateVariant;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record LootCrateLootComponent(class_5321<class_52> lootTable, long seed, LockMode lockMode, ReplenishTimeScale replenishTimeScale, long replenishTime, InventoryDeletionMode inventoryDeletionMode, boolean trackedPerPlayer, boolean trapped) {
    public static final Codec<LootCrateLootComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_50079).fieldOf("loot_table").forGetter(LootCrateLootComponent::lootTable), (App)Codec.LONG.optionalFieldOf("seed", (Object)0L).forGetter(LootCrateLootComponent::seed), (App)LockMode.CODEC.optionalFieldOf("lock_mode", (Object)LockMode.NOT_LOCKED).forGetter(LootCrateLootComponent::lockMode), (App)ReplenishTimeScale.CODEC.optionalFieldOf("replenish_time_scale", (Object)ReplenishTimeScale.NEVER).forGetter(LootCrateLootComponent::replenishTimeScale), (App)Codec.LONG.optionalFieldOf("replenish_time", (Object)-1L).forGetter(LootCrateLootComponent::replenishTime), (App)InventoryDeletionMode.CODEC.optionalFieldOf("inventory_deletion_mode", (Object)InventoryDeletionMode.NEVER).forGetter(LootCrateLootComponent::inventoryDeletionMode), (App)Codec.BOOL.optionalFieldOf("tracked_per_player", (Object)false).forGetter(LootCrateLootComponent::trackedPerPlayer), (App)Codec.BOOL.optionalFieldOf("trapped", (Object)false).forGetter(LootCrateLootComponent::trapped)).apply((Applicative)instance, LootCrateLootComponent::new));

    public boolean isUnlocked(Optional<PlayerCrateData> playerCrateData) {
        return this.lockMode.isUnlocked(playerCrateData);
    }

    public void appendTooltip(LootCrateVariant variant, Optional<PlayerCrateData> playerCrateData, class_1937 world, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        boolean advanced;
        if (playerCrateData.isEmpty() || playerCrateData.get().replenishTime() < 0L || this.replenishTimeScale.canReplenish(world, playerCrateData, this.replenishTime)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.lootcrates.loot_crate.tooltip.contains_loot"));
        } else if (this.trackedPerPlayer) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.lootcrates.loot_crate.tooltip.already_looted_by_you"));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.lootcrates.loot_crate.tooltip.already_looted"));
        }
        if (!this.lockMode.isUnlocked(playerCrateData)) {
            tooltip.add(LootCrateAtlas.getItemLockedTooltip(variant, this.lockMode));
        }
        switch (this.replenishTimeScale) {
            case HOURS: {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.lootcrates.loot_crate.tooltip.replenish_hourly"));
                break;
            }
            case DAYS: {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.lootcrates.loot_crate.tooltip.replenish_daily"));
                break;
            }
            case WEEKS: {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.lootcrates.loot_crate.tooltip.replenish_weekly"));
                break;
            }
            case MONTHS: {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.lootcrates.loot_crate.tooltip.replenish_monthly"));
                break;
            }
            case TICKS: {
                class_2561 text = LootCrateLootComponent.getReplenishTimeGameTimeHumanReadableText(this.replenishTime);
                if (text == null) break;
                tooltip.add(text);
                break;
            }
            case SECONDS: {
                class_2561 text = LootCrateLootComponent.getReplenishTimeRealTimeHumanReadableText(this.replenishTime);
                if (text == null) break;
                tooltip.add(text);
            }
        }
        if (this.trackedPerPlayer) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.lootcrates.loot_crate.tooltip.tracked_per_player"));
        }
        if (this.lockMode.relocks()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.lootcrates.loot_crate.tooltip.relocks"));
        }
        switch (this.inventoryDeletionMode) {
            case ON_OPEN: {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.lootcrates.loot_crate.tooltip.inventory_deletes_on_open"));
                break;
            }
            case WHEN_REPLENISHED: {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.lootcrates.loot_crate.tooltip.inventory_deletes_when_replenished"));
            }
        }
        if (this.trapped) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.lootcrates.loot_crate.tooltip.trapped"));
        }
        if (advanced = type.method_8035()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.lootcrates.loot_crate.tooltip.loot_table", (Object[])new Object[]{this.lootTable.method_29177().toString()}));
            if (this.seed != 0L) {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.lootcrates.loot_crate.tooltip.fixed_seed", (Object[])new Object[]{this.seed}));
            }
        }
    }

    @Nullable
    public static class_2561 getReplenishTimeGameTimeHumanReadableText(long replenishTime) {
        if (replenishTime >= 1728000L) {
            return class_2561.method_43469((String)"item.lootcrates.loot_crate.tooltip.replenish_game_time_days", (Object[])new Object[]{Float.valueOf((float)replenishTime / 1728000.0f)});
        }
        if (replenishTime >= 72000L) {
            return class_2561.method_43469((String)"item.lootcrates.loot_crate.tooltip.replenish_game_time_hours", (Object[])new Object[]{Float.valueOf((float)replenishTime / 72000.0f)});
        }
        if (replenishTime >= 1200L) {
            return class_2561.method_43469((String)"item.lootcrates.loot_crate.tooltip.replenish_game_time_minutes", (Object[])new Object[]{Float.valueOf((float)replenishTime / 1200.0f)});
        }
        if (replenishTime <= 0L) {
            return null;
        }
        return class_2561.method_43469((String)"item.lootcrates.loot_crate.tooltip.replenish_game_time_ticks", (Object[])new Object[]{replenishTime});
    }

    @Nullable
    public static class_2561 getReplenishTimeRealTimeHumanReadableText(long replenishTime) {
        if (replenishTime >= 1728000L) {
            return class_2561.method_43469((String)"item.lootcrates.loot_crate.tooltip.replenish_real_time_days", (Object[])new Object[]{Float.valueOf((float)replenishTime / 1728000.0f)});
        }
        if (replenishTime >= 72000L) {
            return class_2561.method_43469((String)"item.lootcrates.loot_crate.tooltip.replenish_real_time_hours", (Object[])new Object[]{Float.valueOf((float)replenishTime / 72000.0f)});
        }
        if (replenishTime >= 1200L) {
            return class_2561.method_43469((String)"item.lootcrates.loot_crate.tooltip.replenish_real_time_minutes", (Object[])new Object[]{Float.valueOf((float)replenishTime / 1200.0f)});
        }
        if (replenishTime <= 0L) {
            return null;
        }
        return class_2561.method_43469((String)"item.lootcrates.loot_crate.tooltip.replenish_real_time_ticks", (Object[])new Object[]{replenishTime});
    }
}

