/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.lootcrates.blocks.shulker;

import de.dafuqs.lootcrates.blocks.LootCrateBlockEntity;
import de.dafuqs.lootcrates.blocks.LootCratesBlockEntityType;
import de.dafuqs.lootcrates.blocks.shulker.ShulkerLootCrateBlock;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1606;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1733;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import org.jetbrains.annotations.Nullable;

public class ShulkerLootCrateBlockEntity
extends LootCrateBlockEntity
implements class_1278 {
    private int viewerCount;
    private class_2627.class_2628 animationStage = class_2627.class_2628.field_12065;
    private float animationProgress;
    private float prevAnimationProgress;
    private static final int[] AVAILABLE_SLOTS = IntStream.range(0, 27).toArray();

    public ShulkerLootCrateBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public ShulkerLootCrateBlockEntity(class_2338 pos, class_2680 state) {
        this(LootCratesBlockEntityType.SHULKER_LOOT_CRATE_BLOCK_ENTITY, pos, state);
    }

    @Override
    protected void onInvOpenOrClose(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
        super.onInvOpenOrClose(world, pos, state, oldViewerCount, newViewerCount);
    }

    @Override
    public int getCurrentLookingPlayers(class_1922 world, class_2338 pos) {
        return this.viewerCount;
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new class_1733(syncId, playerInventory, (class_1263)this);
    }

    public boolean suffocates() {
        return this.animationStage == class_2627.class_2628.field_12065;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ShulkerLootCrateBlockEntity blockEntity) {
        blockEntity.updateAnimation(world, pos, state);
    }

    private void updateAnimation(class_1937 world, class_2338 pos, class_2680 state) {
        this.prevAnimationProgress = this.animationProgress;
        switch (this.animationStage) {
            case field_12065: {
                this.animationProgress = 0.0f;
                break;
            }
            case field_12066: {
                this.animationProgress += 0.1f;
                if (this.animationProgress >= 1.0f) {
                    this.animationStage = class_2627.class_2628.field_12063;
                    this.animationProgress = 1.0f;
                    ShulkerLootCrateBlockEntity.updateNeighborStates(world, pos, state);
                }
                this.pushEntities(world, pos, state);
                break;
            }
            case field_12064: {
                this.animationProgress -= 0.1f;
                if (!(this.animationProgress <= 0.0f)) break;
                this.animationStage = class_2627.class_2628.field_12065;
                this.animationProgress = 0.0f;
                ShulkerLootCrateBlockEntity.updateNeighborStates(world, pos, state);
                break;
            }
            case field_12063: {
                this.animationProgress = 1.0f;
            }
        }
    }

    private void pushEntities(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 direction;
        class_238 box;
        List list;
        if (state.method_26204() instanceof ShulkerLootCrateBlock && !(list = world.method_8335(null, box = class_1606.method_33347((float)1.0f, (class_2350)(direction = (class_2350)state.method_11654((class_2769)class_2480.field_11496)), (float)this.prevAnimationProgress, (float)this.animationProgress).method_996(pos))).isEmpty()) {
            for (class_1297 entity : list) {
                if (entity.method_5657() == class_3619.field_15975) continue;
                entity.method_5784(class_1313.field_6306, new class_243((box.method_17939() + 0.01) * (double)direction.method_10148(), (box.method_17940() + 0.01) * (double)direction.method_10164(), (box.method_17941() + 0.01) * (double)direction.method_10165()));
            }
        }
    }

    private static void updateNeighborStates(class_1937 world, class_2338 pos, class_2680 state) {
        state.method_30101((class_1936)world, pos, 3);
    }

    public class_2627.class_2628 getAnimationStage() {
        return this.animationStage;
    }

    public class_238 getBoundingBox(class_2680 state) {
        return this.getBoundingBox((class_2350)state.method_11654((class_2769)class_2480.field_11496));
    }

    public class_238 getBoundingBox(class_2350 openDirection) {
        float f = this.getAnimationProgress(1.0f);
        return class_259.method_1077().method_1107().method_1012((double)(0.5f * f * (float)openDirection.method_10148()), (double)(0.5f * f * (float)openDirection.method_10164()), (double)(0.5f * f * (float)openDirection.method_10165()));
    }

    public boolean method_11004(int type, int data) {
        if (type == 1) {
            this.viewerCount = data;
            if (data == 0) {
                this.animationStage = class_2627.class_2628.field_12064;
                this.updateNeighborStates();
            } else if (data == 1) {
                this.animationStage = class_2627.class_2628.field_12066;
                this.updateNeighborStates();
            }
            return true;
        }
        return super.method_11004(type, data);
    }

    private void updateNeighborStates() {
        this.method_11010().method_30101((class_1936)this.method_10997(), this.method_11016(), 3);
    }

    public void method_5435(class_1657 player) {
        if (!player.method_7325() && this.method_11002()) {
            if (this.viewerCount < 0) {
                this.viewerCount = 0;
            }
            ++this.viewerCount;
            this.onInvOpenOrClose(this.field_11863, this.field_11867, this.field_11863.method_8320(this.field_11867), this.viewerCount - 1, this.viewerCount);
            this.field_11863.method_8427(this.field_11867, this.method_11010().method_26204(), 1, this.viewerCount);
            if (this.viewerCount == 1) {
                this.playOpenSoundEffect();
            }
        }
    }

    public void method_5432(class_1657 player) {
        if (!player.method_7325() && this.method_11002()) {
            --this.viewerCount;
            this.onInvOpenOrClose(this.field_11863, this.field_11867, this.field_11863.method_8320(this.field_11867), this.viewerCount + 1, this.viewerCount);
            this.field_11863.method_8427(this.field_11867, this.method_11010().method_26204(), 1, this.viewerCount);
            if (this.viewerCount <= 0) {
                this.playCloseSoundEffect();
            }
        }
    }

    public float getAnimationProgress(float f) {
        return class_3532.method_16439((float)f, (float)this.prevAnimationProgress, (float)this.animationProgress);
    }

    public int[] method_5494(class_2350 side) {
        return AVAILABLE_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return !(class_2248.method_9503((class_1792)stack.method_7909()) instanceof class_2480);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }
}

