/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.lootcrates.blocks;

import de.dafuqs.lootcrates.LootCrateAtlas;
import de.dafuqs.lootcrates.LootCrates;
import de.dafuqs.lootcrates.blocks.LootCrateBlock;
import de.dafuqs.lootcrates.blocks.chest.ChestLootCrateBlockEntity;
import de.dafuqs.lootcrates.components.InventoryDeletionMode;
import de.dafuqs.lootcrates.components.LockMode;
import de.dafuqs.lootcrates.components.LootCrateDataComponentTypes;
import de.dafuqs.lootcrates.components.LootCrateLootComponent;
import de.dafuqs.lootcrates.components.LootCratePlayerDataComponent;
import de.dafuqs.lootcrates.components.PlayerCrateData;
import de.dafuqs.lootcrates.components.ReplenishTimeScale;
import de.dafuqs.lootcrates.enums.LootCrateVariant;
import de.dafuqs.lootcrates.enums.ScheduledTickEvent;
import de.dafuqs.lootcrates.items.LootKeyItem;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import net.minecraft.class_8934;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LootCrateBlockEntity
extends class_2624
implements class_8934 {
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    private ScheduledTickEvent scheduledTickEvent;

    protected LootCrateBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (nbt.method_10573("Items", 9)) {
            class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        }
    }

    public int method_5439() {
        return this.inventory.size();
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.inventory = inventory;
    }

    protected void playSound(class_3414 soundEvent) {
        this.playSound(soundEvent, 1.0f);
    }

    protected void playSound(class_3414 soundEvent, float volume) {
        if (this.method_11002()) {
            double d = (double)this.field_11867.method_10263() + 0.5;
            double e = (double)this.field_11867.method_10264() + 0.5;
            double f = (double)this.field_11867.method_10260() + 0.5;
            this.field_11863.method_43128(null, d, e, f, soundEvent, class_3419.field_15245, 0.5f * volume, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
        }
    }

    public Optional<PlayerCrateData> getPlayerCrateData(class_1657 playerEntity) {
        @Nullable LootCrateLootComponent lootComponent = (LootCrateLootComponent)this.method_58693().method_57829(LootCrateDataComponentTypes.LOOT_CRATE_LOOT);
        if (lootComponent == null) {
            return Optional.empty();
        }
        LootCratePlayerDataComponent playerDataComponent = (LootCratePlayerDataComponent)this.method_58693().method_57829(LootCrateDataComponentTypes.LOOT_CRATE_PLAYER_DATA);
        if (playerDataComponent == null) {
            return Optional.empty();
        }
        return playerDataComponent.get(playerEntity, lootComponent.trackedPerPlayer());
    }

    private void setReplenishTimeToNow(class_1657 player) {
        class_9323 components = this.method_58693();
        @Nullable LootCratePlayerDataComponent playerDataComponent = (LootCratePlayerDataComponent)components.method_57829(LootCrateDataComponentTypes.LOOT_CRATE_PLAYER_DATA);
        LootCrateLootComponent lootComponent = (LootCrateLootComponent)components.method_57829(LootCrateDataComponentTypes.LOOT_CRATE_LOOT);
        if (lootComponent == null) {
            return;
        }
        LootCratePlayerDataComponent newComponent = LootCratePlayerDataComponent.setReplenishedForPlayer(playerDataComponent, player, lootComponent.trackedPerPlayer(), lootComponent.replenishTimeScale());
        class_9323.class_9324 builder = class_9323.method_57827().method_57839(components).method_57840(LootCrateDataComponentTypes.LOOT_CRATE_PLAYER_DATA, (Object)newComponent);
        this.method_58684(builder.method_57838());
        this.method_5431();
    }

    public boolean canReplenish(LootCrateLootComponent lootComponent, class_1657 player) {
        if (this.method_11002()) {
            Optional<PlayerCrateData> playerCrateDataOptional = this.getPlayerCrateData(player);
            if (playerCrateDataOptional.isEmpty()) {
                return true;
            }
            return LootCrateBlockEntity.canReplenish(this.field_11863, playerCrateDataOptional, lootComponent.replenishTimeScale(), lootComponent.replenishTime());
        }
        return false;
    }

    public static boolean canReplenish(class_1937 world, Optional<PlayerCrateData> playerCrateData, ReplenishTimeScale replenishTimeScale, long replenishTimeTicks) {
        if (playerCrateData.isEmpty()) {
            return true;
        }
        return replenishTimeScale.canReplenish(world, playerCrateData, replenishTimeTicks);
    }

    public boolean method_5442() {
        return this.method_11282().stream().allMatch(class_1799::method_7960);
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
        if (this.method_17489(playerEntity)) {
            this.method_54873(playerInventory.field_7546);
            return this.method_5465(i, playerInventory);
        }
        return null;
    }

    public void method_54873(@Nullable class_1657 player) {
        boolean canGenerateNewLoot;
        @Nullable LootCrateLootComponent lootComponent = (LootCrateLootComponent)this.method_58693().method_57829(LootCrateDataComponentTypes.LOOT_CRATE_LOOT);
        if (lootComponent == null) {
            return;
        }
        boolean inventoryCleared = false;
        if (lootComponent.inventoryDeletionMode() == InventoryDeletionMode.ON_OPEN) {
            this.method_5448();
            inventoryCleared = true;
        }
        if (!(canGenerateNewLoot = this.canReplenish(lootComponent, player))) {
            return;
        }
        if (!inventoryCleared && lootComponent.inventoryDeletionMode() == InventoryDeletionMode.WHEN_REPLENISHED) {
            this.method_5448();
        }
        this.setReplenishTimeToNow(player);
        class_1937 world = this.method_10997();
        class_2338 blockPos = this.method_11016();
        class_5321<class_52> registryKey = lootComponent.lootTable();
        if (registryKey != null && world != null && world.method_8503() != null) {
            class_52 lootTable = world.method_8503().method_58576().method_58295(registryKey);
            if (player instanceof class_3222) {
                class_174.field_24479.method_27993((class_3222)player, registryKey);
            }
            class_8567.class_8568 builder = new class_8567.class_8568((class_3218)world).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockPos));
            if (player != null) {
                builder.method_51871(player.method_7292()).method_51874(class_181.field_1226, (Object)player);
            }
            lootTable.method_329((class_1263)this, builder.method_51875(class_173.field_1179), lootComponent.seed());
        }
    }

    @Nullable
    public class_5321<class_52> method_54869() {
        @Nullable LootCrateLootComponent lootComponent = (LootCrateLootComponent)this.method_58693().method_57829(LootCrateDataComponentTypes.LOOT_CRATE_LOOT);
        if (lootComponent == null) {
            return null;
        }
        return lootComponent.lootTable();
    }

    public long method_54870() {
        @Nullable LootCrateLootComponent lootComponent = (LootCrateLootComponent)this.method_58693().method_57829(LootCrateDataComponentTypes.LOOT_CRATE_LOOT);
        if (lootComponent == null) {
            return 0L;
        }
        return lootComponent.seed();
    }

    public void method_11285(@Nullable class_5321<class_52> lootTable) {
    }

    public void method_54866(long lootTableSeed) {
    }

    protected void onInvOpenOrClose(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
        if (this.isTrapped() && oldViewerCount != newViewerCount) {
            class_2248 block = state.method_26204();
            world.method_8452(pos, block);
            world.method_8452(pos.method_10074(), block);
        }
    }

    protected class_2561 method_17823() {
        class_2680 state = this.method_11010();
        class_5250 name = state.method_26204().method_9518();
        if (name.getString().startsWith("\u00a7")) {
            return class_2561.method_43470((String)name.getString().substring(2));
        }
        return name;
    }

    public void relockIfNecessary(class_1657 player) {
        @Nullable LootCrateLootComponent lootComponent = (LootCrateLootComponent)this.method_58693().method_57829(LootCrateDataComponentTypes.LOOT_CRATE_LOOT);
        if (lootComponent == null) {
            return;
        }
        Optional<PlayerCrateData> playerCrateDataOptional = this.getPlayerCrateData(player);
        if (LootCrateBlockEntity.shouldRelock(this.field_11863, lootComponent.replenishTimeScale(), lootComponent.replenishTime(), lootComponent.lockMode(), playerCrateDataOptional)) {
            class_9323 components = this.method_58693();
            @Nullable LootCratePlayerDataComponent playerDataComponent = (LootCratePlayerDataComponent)components.method_57829(LootCrateDataComponentTypes.LOOT_CRATE_PLAYER_DATA);
            @Nullable LootCratePlayerDataComponent newComponent = LootCratePlayerDataComponent.lockForPlayer(playerDataComponent, player, lootComponent.trackedPerPlayer());
            class_9323.class_9324 builder = class_9323.method_57827().method_57839(components).method_57840(LootCrateDataComponentTypes.LOOT_CRATE_PLAYER_DATA, (Object)newComponent);
            this.method_58684(builder.method_57838());
            this.method_5431();
        }
    }

    private static boolean shouldRelock(class_1937 world, ReplenishTimeScale replenishTimeScale, long replenishTimeTicks, LockMode lockMode, Optional<PlayerCrateData> playerCrateData) {
        if (lockMode.relocks() && playerCrateData.isPresent()) {
            return playerCrateData.get().unlockTime() < playerCrateData.get().replenishTime() && LootCrateBlockEntity.canReplenish(world, playerCrateData, replenishTimeScale, replenishTimeTicks);
        }
        return false;
    }

    public boolean isUnlocked(class_1657 player) {
        @Nullable LootCrateLootComponent lootComponent = (LootCrateLootComponent)this.method_58693().method_57829(LootCrateDataComponentTypes.LOOT_CRATE_LOOT);
        if (lootComponent == null) {
            return true;
        }
        Optional<PlayerCrateData> optionalPlayerCrateData = this.getPlayerCrateData(player);
        return lootComponent.isUnlocked(optionalPlayerCrateData);
    }

    public boolean doesItemUnlock(class_1792 item) {
        if (this.field_11863 != null && item instanceof LootKeyItem) {
            LootKeyItem lootKeyItem = (LootKeyItem)item;
            Optional<LootCrateBlock> block = this.getBlock();
            if (block.isPresent()) {
                LootCrateVariant itemVariant = lootKeyItem.getVariant();
                LootCrateVariant blockVariant = block.get().getVariant();
                return itemVariant.equals((Object)blockVariant);
            }
        }
        return false;
    }

    public void unlockFor(class_1657 player) {
        class_9323 components = this.method_58693();
        @Nullable LootCrateLootComponent lootComponent = (LootCrateLootComponent)components.method_57829(LootCrateDataComponentTypes.LOOT_CRATE_LOOT);
        if (lootComponent == null) {
            return;
        }
        @Nullable LootCratePlayerDataComponent playerDataComponent = (LootCratePlayerDataComponent)components.method_57829(LootCrateDataComponentTypes.LOOT_CRATE_PLAYER_DATA);
        LootCratePlayerDataComponent newComponent = LootCratePlayerDataComponent.unlockForPlayer(playerDataComponent, player, lootComponent.trackedPerPlayer(), lootComponent.replenishTimeScale());
        class_9323.class_9324 builder = class_9323.method_57827().method_57839(components).method_57840(LootCrateDataComponentTypes.LOOT_CRATE_PLAYER_DATA, (Object)newComponent);
        this.method_58684(builder.method_57838());
        this.method_5431();
        this.playSound(LootCrates.CHEST_UNLOCKS_SOUND_EVENT);
    }

    public Optional<LootCrateBlock> getBlock() {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        class_2248 block = this.field_11863.method_8320(this.field_11867).method_26204();
        if (block instanceof LootCrateBlock) {
            LootCrateBlock lootCrateBlock = (LootCrateBlock)block;
            return Optional.of(lootCrateBlock);
        }
        return Optional.empty();
    }

    public ScheduledTickEvent getRandomTickEvent() {
        if (this.scheduledTickEvent == null) {
            Optional<LootCrateBlock> block = this.getBlock();
            block.ifPresent(lootCrateBlock -> {
                this.scheduledTickEvent = LootCrateAtlas.getRandomTickEvent(lootCrateBlock);
            });
        }
        return this.scheduledTickEvent;
    }

    public void playOpenSoundEffect() {
        class_3414 customSoundEvent;
        if (this instanceof ChestLootCrateBlockEntity) {
            this.playSound(class_3417.field_14982);
        } else {
            this.playSound(class_3417.field_14825);
        }
        Optional<LootCrateBlock> block = this.getBlock();
        if (block.isPresent() && (customSoundEvent = LootCrateAtlas.getCustomOpenSoundEvent(block.get())) != null) {
            this.playSound(customSoundEvent, 0.4f);
        }
    }

    public void playCloseSoundEffect() {
        class_3414 customSoundEvent;
        if (this instanceof ChestLootCrateBlockEntity) {
            this.playSound(class_3417.field_14823);
        } else {
            this.playSound(class_3417.field_14751);
        }
        Optional<LootCrateBlock> block = this.getBlock();
        if (block.isPresent() && (customSoundEvent = LootCrateAtlas.getCustomCloseSoundEvent(block.get())) != null) {
            this.playSound(customSoundEvent, 0.4f);
        }
    }

    protected static void playSound(@NotNull class_1937 world, @NotNull class_2338 pos, class_2680 state, class_3414 soundEvent) {
        double d = (double)pos.method_10263() + 0.5;
        double e = (double)pos.method_10264() + 0.5;
        double f = (double)pos.method_10260() + 0.5;
        world.method_43128(null, d, e, f, soundEvent, class_3419.field_15245, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f);
    }

    public abstract int getCurrentLookingPlayers(class_1922 var1, class_2338 var2);

    public boolean isTrapped() {
        @Nullable LootCrateLootComponent lootComponent = (LootCrateLootComponent)this.method_58693().method_57829(LootCrateDataComponentTypes.LOOT_CRATE_LOOT);
        if (lootComponent == null) {
            return false;
        }
        return lootComponent.trapped();
    }

    public LockMode getLockType() {
        @Nullable LootCrateLootComponent lootComponent = (LootCrateLootComponent)this.method_58693().method_57829(LootCrateDataComponentTypes.LOOT_CRATE_LOOT);
        if (lootComponent == null) {
            return LockMode.NOT_LOCKED;
        }
        return lootComponent.lockMode();
    }
}

