/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.lootcrates.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.lootcrates.LootCrateAtlas;
import de.dafuqs.lootcrates.blocks.LootCrateBlockEntity;
import de.dafuqs.lootcrates.blocks.barrel.LootBarrelBlock;
import de.dafuqs.lootcrates.enums.BlockBreakAction;
import de.dafuqs.lootcrates.enums.LootCrateVariant;
import de.dafuqs.lootcrates.enums.ScheduledTickEvent;
import java.util.List;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;

public abstract class LootCrateBlock
extends class_2237 {
    protected final LootCrateVariant variant;
    public static final MapCodec<LootBarrelBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LootCrateVariant.CODEC.fieldOf("variant").forGetter(block -> block.variant), (App)LootCrateBlock.method_54096()).apply((Applicative)instance, LootBarrelBlock::new));
    public static final class_2960 CONTENTS_DYNAMIC_DROP_ID = class_2960.method_60655((String)"lootcrates", (String)"contents");

    protected LootCrateBlock(LootCrateVariant variant, class_4970.class_2251 settings) {
        super(settings);
        this.variant = variant;
    }

    public LootCrateVariant getVariant() {
        return this.variant;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof LootCrateBlockEntity) {
            LootCrateBlockEntity lootCrateBlockEntity = (LootCrateBlockEntity)blockEntity;
            lootCrateBlockEntity.relockIfNecessary(player);
            if (!lootCrateBlockEntity.isUnlocked(player)) {
                for (class_1799 itemStack : player.method_5877()) {
                    if (!lootCrateBlockEntity.doesItemUnlock(itemStack.method_7909())) continue;
                    if (lootCrateBlockEntity.getLockType().consumesKey() && !player.method_7337()) {
                        itemStack.method_7934(1);
                    }
                    lootCrateBlockEntity.unlockFor(player);
                    return class_1269.field_21466;
                }
                if (!world.method_8608()) {
                    class_2561 translatableText = LootCrateAtlas.getKeyNeededTooltip(this.getVariant());
                    player.method_7353(translatableText, true);
                }
                this.playSound(world, pos, class_3417.field_14731);
                return class_1269.field_5814;
            }
        }
        return class_1269.field_5811;
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, @NotNull class_1922 world, class_2338 pos, class_2350 direction) {
        LootCrateBlockEntity lootCrateBlockEntity;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof LootCrateBlockEntity && (lootCrateBlockEntity = (LootCrateBlockEntity)blockEntity).isTrapped()) {
            return class_3532.method_15340((int)LootCrateBlock.getPlayersLookingInCrateCount(world, pos), (int)0, (int)15);
        }
        return 0;
    }

    public int method_9603(class_2680 state, @NotNull class_1922 world, class_2338 pos, class_2350 direction) {
        LootCrateBlockEntity lootCrateBlockEntity;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof LootCrateBlockEntity && (lootCrateBlockEntity = (LootCrateBlockEntity)blockEntity).isTrapped()) {
            return direction == class_2350.field_11036 ? state.method_26195(world, pos, direction) : 0;
        }
        return 0;
    }

    public static int getPlayersLookingInCrateCount(@NotNull class_1922 world, class_2338 pos) {
        class_2586 blockEntity;
        class_2680 blockState = world.method_8320(pos);
        if (blockState.method_31709() && (blockEntity = world.method_8321(pos)) instanceof LootCrateBlockEntity) {
            LootCrateBlockEntity lootCrateBlockEntity = (LootCrateBlockEntity)blockEntity;
            return lootCrateBlockEntity.getCurrentLookingPlayers(world, pos);
        }
        return 0;
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int zOffset;
        int yOffset;
        int xOffset;
        class_2338 targetPos;
        ScheduledTickEvent scheduledTickEvent;
        world.method_39279(pos, (class_2248)this, LootCrateBlock.getRandomTickTime(world.field_9229));
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof LootCrateBlockEntity && (scheduledTickEvent = ((LootCrateBlockEntity)blockEntity).getRandomTickEvent()) == ScheduledTickEvent.FIRE && world.method_8450().method_8355(class_1928.field_19387) && world.method_8320(targetPos = pos.method_10069(xOffset = 2 - random.method_43048(5), yOffset = 1 - random.method_43048(3), zOffset = 2 - random.method_43048(5))).method_26215() && world.method_8320(targetPos.method_10074()).method_51367()) {
            world.method_8501(targetPos, class_2246.field_10036.method_9564());
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        ScheduledTickEvent scheduledTickEvent;
        super.method_9615(state, world, pos, oldState, notify);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof LootCrateBlockEntity && (scheduledTickEvent = ((LootCrateBlockEntity)blockEntity).getRandomTickEvent()) != ScheduledTickEvent.NONE) {
            world.method_39279(pos, (class_2248)this, LootCrateBlock.getRandomTickTime(world.field_9229));
        }
    }

    private static int getRandomTickTime(@NotNull class_5819 random) {
        return 20 + random.method_43048(10);
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof LootCrateBlockEntity) {
            LootCrateBlockEntity lootCrateBlockEntity = (LootCrateBlockEntity)blockEntity;
            if (!world.field_9236 && player.method_7337() && !lootCrateBlockEntity.method_5442()) {
                class_1799 itemStack = new class_1799((class_1935)this);
                itemStack.method_57365(blockEntity.method_57590());
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
                itemEntity.method_6988();
                world.method_8649((class_1297)itemEntity);
            } else {
                lootCrateBlockEntity.method_54873(player);
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        BlockBreakAction blockBreakAction = this.getBlockBreakAction();
        switch (blockBreakAction) {
            case KEEP_INVENTORY: {
                if (state.method_27852(newState.method_26204())) break;
                class_2586 blockEntity = world.method_8321(pos);
                if (blockEntity instanceof LootCrateBlockEntity) {
                    world.method_8455(pos, state.method_26204());
                }
                super.method_9536(state, world, pos, newState, moved);
                break;
            }
            case DROP_AND_SCATTER_INVENTORY: 
            case DESTROY_AND_SCATTER_INVENTORY: {
                class_1264.method_54291((class_2680)state, (class_2680)newState, (class_1937)world, (class_2338)pos);
            }
        }
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        BlockBreakAction blockBreakAction = this.getBlockBreakAction();
        switch (blockBreakAction) {
            case KEEP_INVENTORY: 
            case DROP_AND_SCATTER_INVENTORY: {
                class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
                if (!(blockEntity instanceof LootCrateBlockEntity)) break;
                LootCrateBlockEntity lootCrateBlockEntity = (LootCrateBlockEntity)blockEntity;
                builder = builder.method_51872(CONTENTS_DYNAMIC_DROP_ID, lootConsumer -> {
                    for (int i = 0; i < lootCrateBlockEntity.method_5439(); ++i) {
                        lootConsumer.accept(lootCrateBlockEntity.method_5438(i));
                    }
                });
                break;
            }
        }
        return super.method_9560(state, builder);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, @NotNull class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    protected abstract BlockBreakAction getBlockBreakAction();

    protected void playSound(@NotNull class_1937 world, @NotNull class_2338 blockPos, class_3414 soundEvent) {
        double d = (double)blockPos.method_10263() + 0.5;
        double e = (double)blockPos.method_10264() + 0.5;
        double f = (double)blockPos.method_10260() + 0.5;
        world.method_43128(null, d, e, f, soundEvent, class_3419.field_15245, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f);
    }
}

