/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.iceberg.events.client.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.services.IKeyMappingRegistrar;
import com.anthonyhilyard.iceberg.services.Services;
import com.anthonyhilyard.iceberg.util.Tooltips;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.tooltip.ItemModelComponent;
import com.anthonyhilyard.legendarytooltips.tooltip.TooltipDecor;
import com.anthonyhilyard.legendarytooltips.tooltip.TooltipScroll;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2588;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import net.minecraft.class_9779;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LegendaryTooltips {
    public static final String MODID = "legendarytooltips";
    public static final Logger LOGGER = LogManager.getLogger((String)"legendarytooltips");
    public static final int NUM_FRAMES = 16;
    private static Map<Integer, class_1799> lastTooltipItems = Maps.newHashMap();
    public static final class_304 scrollTooltips = Services.getKeyMappingRegistrar().registerMapping(new class_304("legendarytooltips.key.scrollTooltips", class_3675.class_307.field_1668, 340, "key.categories.inventory"), IKeyMappingRegistrar.KeyMappingContext.NO_CONFLICT);
    public static boolean scrollTooltipsKeyDown = false;

    public static void init() {
        LegendaryTooltipsConfig.register(LegendaryTooltipsConfig.class, (String)MODID);
    }

    public static RenderTooltipEvents.GatherResult onGatherComponentsEvent(class_1799 itemStack, int screenWidth, int screenHeight, List<Either<class_5348, class_5632>> tooltipElements, int maxWidth, int index) {
        if (LegendaryTooltipsConfig.getInstance().compactTooltips.get().booleanValue()) {
            for (int i = 0; i < tooltipElements.size(); ++i) {
                class_2588 contents;
                class_5250 component;
                class_7417 class_74172;
                class_5348 text;
                if (!tooltipElements.get(i).left().isPresent() || !((text = (class_5348)tooltipElements.get(i).left().get()) instanceof class_5250) || !((class_74172 = (component = (class_5250)text).method_10851()) instanceof class_2588) || !(contents = (class_2588)class_74172).method_11022().startsWith("item.modifiers.")) continue;
                tooltipElements.remove(i);
                if ((tooltipElements.size() <= i - 1 || i <= 0 || !tooltipElements.get(i - 1).right().isPresent() || tooltipElements.get(i - 1).right().get() != class_5244.field_39003) && (!tooltipElements.get(i - 1).left().isPresent() || !((class_5348)tooltipElements.get(i - 1).left().get()).getString().isEmpty())) continue;
                tooltipElements.remove(i - 1);
            }
        }
        if (LegendaryTooltipsConfig.showModelForItem(itemStack) && !tooltipElements.isEmpty() && tooltipElements.get(0).left().isPresent()) {
            tooltipElements.add(0, (Either<class_5348, class_5632>)Either.right((Object)new ItemModelComponent(itemStack)));
        }
        if (LegendaryTooltipsConfig.getMaxTooltipWidth() < maxWidth || maxWidth == -1) {
            maxWidth = LegendaryTooltipsConfig.getMaxTooltipWidth();
        }
        return new RenderTooltipEvents.GatherResult(class_1269.field_5811, maxWidth, tooltipElements);
    }

    public static void onRenderTick(class_9779 tracker) {
        if (LegendaryTooltipsConfig.getInstance() == null || !LegendaryTooltipsConfig.getInstance().isLoaded()) {
            return;
        }
        float deltaTime = tracker.method_60638() * 0.05f;
        TooltipDecor.updateTimer(deltaTime);
        ItemModelComponent.updateTimer(deltaTime);
        if (!Tooltips.anyTooltipsVisible()) {
            TooltipDecor.resetTimer();
            TooltipScroll.resetAll();
            lastTooltipItems.clear();
        }
    }

    private static boolean areStacksEqual(class_1799 first, class_1799 second) {
        if (first == second) {
            return true;
        }
        return class_1799.method_57355((class_1799)first) + first.method_7947() == class_1799.method_57355((class_1799)second) + second.method_7947();
    }

    public static RenderTooltipEvents.ColorExtResult onTooltipColorEvent(class_1799 stack, class_332 graphics, int x, int y, class_327 font, int backgroundStart, int backgroundEnd, int borderStart, int borderEnd, List<class_5684> components, boolean comparison, int index) {
        RenderTooltipEvents.ColorExtResult result = new RenderTooltipEvents.ColorExtResult(backgroundStart, backgroundEnd, borderStart, borderEnd);
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null || minecraft.field_1687.method_30349() == null) {
            return result;
        }
        if (!LegendaryTooltips.areStacksEqual(lastTooltipItems.computeIfAbsent(index, k -> class_1799.field_8037), stack)) {
            TooltipDecor.resetTimer();
            TooltipScroll.reset(index);
            lastTooltipItems.put(index, stack);
        }
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltipsConfig.getDefinitionColors(stack, borderStart, borderEnd, backgroundStart, backgroundEnd, (class_7225.class_7874)minecraft.field_1687.method_30349());
        TooltipDecor.setCurrentTooltipBorderStart(frameDefinition.startBorder().get());
        TooltipDecor.setCurrentTooltipBorderEnd(frameDefinition.endBorder().get());
        TooltipDecor.setCurrentTooltipBackgroundStart(frameDefinition.startBackground().get());
        TooltipDecor.setCurrentTooltipBackgroundEnd(frameDefinition.endBackground().get());
        return new RenderTooltipEvents.ColorExtResult(frameDefinition.startBackground().get().intValue(), frameDefinition.endBackground().get().intValue(), frameDefinition.startBorder().get().intValue(), frameDefinition.endBorder().get().intValue());
    }

    public static void onPostTooltipEvent(class_1799 stack, class_332 graphics, int x, int y, class_327 font, int width, int height, List<class_5684> components, boolean comparison, int index) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null || minecraft.field_1687.method_30349() == null) {
            return;
        }
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltipsConfig.getInstance().getFrameDefinition(stack, (class_7225.class_7874)minecraft.field_1687.method_30349());
        class_4587 poseStack = graphics.method_51448();
        if (LegendaryTooltipsConfig.getInstance().tooltipShadow.get().booleanValue()) {
            TooltipDecor.drawShadow(poseStack, x, y, width, height);
        }
        TooltipDecor.drawBorder(poseStack, x, y, width, height, stack, components, font, frameDefinition, comparison, index);
    }
}

