/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.mixin;

import com.anthonyhilyard.iceberg.component.IExtendedText;
import com.anthonyhilyard.iceberg.util.Tooltips;
import net.minecraft.class_327;
import net.minecraft.class_5683;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_5683.class})
public class ClientTextTooltipMixin
implements IExtendedText {
    @Unique
    class_327 currentFont;
    @Unique
    IExtendedText.TextAlignment textAlignment = IExtendedText.TextAlignment.LEFT;
    @Unique
    int leftPadding = 0;
    @Unique
    int rightPadding = 0;
    @Unique
    int topPadding = 0;
    @Unique
    int bottomPadding = 0;

    @Override
    public void setAlignment(IExtendedText.TextAlignment alignment) {
        this.textAlignment = alignment;
    }

    @Override
    public void setPadding(int left, int right, int top, int bottom) {
        this.leftPadding = left;
        this.rightPadding = right;
        this.topPadding = top;
        this.bottomPadding = bottom;
    }

    @Override
    public IExtendedText.TextAlignment getAlignment() {
        return this.textAlignment;
    }

    @Override
    public int getLeftPadding() {
        return this.leftPadding;
    }

    @Override
    public int getRightPadding() {
        return this.rightPadding;
    }

    @Override
    public int getTopPadding() {
        return this.topPadding;
    }

    @Override
    public int getBottomPadding() {
        return this.bottomPadding;
    }

    @ModifyVariable(method={"renderText"}, at=@At(value="LOAD"), argsOnly=true, index=1)
    private class_327 getFont(class_327 font) {
        this.currentFont = font;
        return font;
    }

    @ModifyVariable(method={"renderText"}, at=@At(value="LOAD"), argsOnly=true, index=2)
    private int modifyHorizontalOffset(int xOriginal) {
        if (this.currentFont == null) {
            return xOriginal;
        }
        int tooltipWidth = Tooltips.getCurrentRect().method_3319();
        return xOriginal + Tooltips.getTitleOffset(tooltipWidth, this.currentFont.method_30880(((class_5683)this).field_27997), this.leftPadding, this.rightPadding, this.textAlignment);
    }

    @ModifyVariable(method={"renderText"}, at=@At(value="LOAD"), argsOnly=true, index=3)
    private int modifyVerticalOffset(int yOriginal) {
        if (this.currentFont == null) {
            return yOriginal;
        }
        return yOriginal + this.topPadding;
    }

    @Inject(method={"getWidth"}, at={@At(value="RETURN")}, cancellable=true)
    private void adjustWidth(class_327 font, CallbackInfoReturnable<Integer> info) {
        info.setReturnValue((Object)Tooltips.getTitleWidth((class_5683)this, font));
    }

    @Inject(method={"getHeight"}, at={@At(value="RETURN")}, cancellable=true)
    private void adjustHeight(CallbackInfoReturnable<Integer> info) {
        int defaultHeight = 10;
        int result = this.topPadding + defaultHeight + this.bottomPadding;
        info.setReturnValue((Object)result);
    }
}

