/*
 * Decompiled with CFR 0.152.
 */
package com.github.slaxlax.fightfirst;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokeball.PokeBallCaptureCalculatedEvent;
import com.cobblemon.mod.common.api.events.pokeball.PokemonCatchRateEvent;
import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.pokeball.catching.CaptureContext;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.PokeBallItem;
import com.cobblemon.mod.common.pokeball.PokeBall;
import fightfirst.ConfigLoader;
import fightfirst.FightFirstConfig;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\u0003R\u001c\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/github/slaxlax/fightfirst/BattleListener;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/events/pokeball/PokeBallCaptureCalculatedEvent;", "event", "", "onPokemonCapture", "(Lcom/cobblemon/mod/common/api/events/pokeball/PokeBallCaptureCalculatedEvent;)V", "Lcom/cobblemon/mod/common/api/events/pokeball/PokemonCatchRateEvent;", "onPokemonCatchRate", "(Lcom/cobblemon/mod/common/api/events/pokeball/PokemonCatchRateEvent;)V", "register", "Lfightfirst/FightFirstConfig;", "kotlin.jvm.PlatformType", "config", "Lfightfirst/FightFirstConfig;", "FightFirst-fabric"})
public final class BattleListener {
    @NotNull
    public static final BattleListener INSTANCE = new BattleListener();
    private static final FightFirstConfig config = ConfigLoader.loadConfig();

    private BattleListener() {
    }

    public final void register() {
        CobblemonEvents.POKEMON_CATCH_RATE.subscribe(Priority.HIGH, (Function1)new Function1<PokemonCatchRateEvent, Unit>((Object)this){

            public final void invoke(@NotNull PokemonCatchRateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((BattleListener)this.receiver).onPokemonCatchRate(p0);
            }
        });
        CobblemonEvents.POKE_BALL_CAPTURE_CALCULATED.subscribe(Priority.HIGH, (Function1)new Function1<PokeBallCaptureCalculatedEvent, Unit>((Object)this){

            public final void invoke(@NotNull PokeBallCaptureCalculatedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((BattleListener)this.receiver).onPokemonCapture(p0);
            }
        });
    }

    public final void onPokemonCapture(@NotNull PokeBallCaptureCalculatedEvent event) {
        boolean isSubjugated;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        class_1309 playerEntity = event.getThrower();
        if (!(playerEntity instanceof class_3222)) {
            return;
        }
        PokeBall thrownBall = event.getPokeBallEntity().getPokeBall();
        if (BattleListener.config.AllowMasterBall && Intrinsics.areEqual((Object)thrownBall, (Object)PokeBalls.INSTANCE.getMASTER_BALL()) || BattleListener.config.AllowQuickBall && Intrinsics.areEqual((Object)thrownBall, (Object)PokeBalls.INSTANCE.getQUICK_BALL())) {
            return;
        }
        PokemonEntity pokeEntity = event.getPokemonEntity();
        String displayName = pokeEntity.getPokemon().getSpecies().getName();
        double hpRatio = (double)pokeEntity.getPokemon().getCurrentHealth() / (double)pokeEntity.getPokemon().getMaxHealth();
        float hpLimit = RangesKt.coerceIn((float)BattleListener.config.MinCaptureHPThreshold, (float)0.01f, (float)1.0f);
        boolean bl = isSubjugated = (double)hpLimit >= hpRatio;
        if (!isSubjugated) {
            event.setCaptureResult(new CaptureContext(1, false, false));
            playerEntity.method_43496((class_2561)class_2561.method_43470((String)("\u00a76" + displayName + "\u00a7f is still too strong. Fight it!")));
            PokeBallItem pokeBallItem = thrownBall.item();
            class_1799 itemStack = new class_1799((class_1935)pokeBallItem);
            if (!((class_3222)playerEntity).method_31548().method_7394(itemStack)) {
                ((class_3222)playerEntity).method_7328(itemStack, false);
            }
            return;
        }
    }

    public final void onPokemonCatchRate(@NotNull PokemonCatchRateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        float bonusCatchRate = BattleListener.config.BonusCatchRate;
        if (bonusCatchRate <= 0.0f) {
            return;
        }
        event.setCatchRate(event.getCatchRate() + bonusCatchRate);
    }
}

