/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.lunarevent.EnhancedCelestialsLunarForecastWorldData;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7066;

public class SetLunarEventCommand {
    private static final DynamicCommandExceptionType ERROR_LUNAR_EVENT_INVALID = new DynamicCommandExceptionType(obj -> class_2561.method_43469((String)"enhancedcelestials.commands.setlunarevent.invalid", (Object[])new Object[]{obj}));

    public static ArgumentBuilder<class_2168, ?> register(CommandDispatcher<class_2168> dispatcher) {
        return class_2170.method_9247((String)"setLunarEvent").then(class_2170.method_9244((String)"lunarEvent", (ArgumentType)class_7066.method_41170(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY)).executes(cs -> SetLunarEventCommand.setLunarEvent((class_2168)cs.getSource(), (class_7066.class_7068<LunarEvent>)class_7066.method_41166((CommandContext)cs, (String)"lunarEvent", EnhancedCelestialsRegistry.LUNAR_EVENT_KEY, (DynamicCommandExceptionType)ERROR_LUNAR_EVENT_INVALID))));
    }

    public static int setLunarEvent(class_2168 source, class_7066.class_7068<LunarEvent> lunarEventResult) {
        class_3218 world = source.method_9225();
        Optional<EnhancedCelestialsLunarForecastWorldData> lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((class_1937)world);
        if (lunarForecastWorldData.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43471((String)"enhancedcelestials.commands.disabled"));
            return 0;
        }
        EnhancedCelestialsLunarForecastWorldData data = lunarForecastWorldData.orElseThrow();
        if (world.method_8419() && data.getDimensionSettings().requiresClearSkies()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Lunar events can only be started during clear skies!"));
            return 0;
        }
        Either unwrap = lunarEventResult.method_41173();
        if (unwrap.left().isPresent()) {
            class_5321 lunarEventResourceKey = (class_5321)unwrap.left().orElseThrow();
            class_2378 lunarEvents = (class_2378)world.method_30349().method_33310(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow();
            if (lunarEvents.method_35842(lunarEventResourceKey) && lunarEvents.method_40290(lunarEventResourceKey).method_40227()) {
                data.setLunarEvent((class_5321<LunarEvent>)lunarEventResourceKey);
                return 1;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid lunar event \"%s\"!".formatted(lunarEventResourceKey.method_29177())));
            return 0;
        }
        if (unwrap.right().isPresent()) {
            Optional possibleTag = ((class_2378)world.method_30349().method_33310(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).orElseThrow()).method_40266((class_6862)unwrap.right().orElseThrow());
            if (possibleTag.isPresent()) {
                class_6885.class_6888 possibleLunarEvents = (class_6885.class_6888)possibleTag.orElseThrow();
                Optional randomLunarEvent = possibleLunarEvents.method_40243(world.field_9229);
                if (randomLunarEvent.isPresent()) {
                    source.method_9211().method_20493(() -> data.setLunarEvent((class_5321<LunarEvent>)((class_5321)((class_6880)randomLunarEvent.orElseThrow()).method_40230().orElseThrow())));
                    return 1;
                }
                source.method_9213((class_2561)class_2561.method_43470((String)"Invalid lunar event tag \"%s\"!".formatted(possibleLunarEvents.method_40251().comp_327())));
                return 0;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid lunar event tag."));
            return 0;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Could not start Lunar Event..."));
        return 0;
    }
}

