/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.client.ColorSettings;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.lunarevent.EnhancedCelestialsLunarForecastWorldData;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ECWorldRenderer {
    public static void changeMoonColor(float partialTicks) {
        class_638 level = class_310.method_1551().field_1687;
        EnhancedCelestials.lunarForecastWorldData((class_1937)level).ifPresent(data -> {
            ColorSettings lastColorSettings = ((LunarEvent)data.lastLunarEventHolder().comp_349()).getClientSettings().colorSettings();
            ColorSettings currentColorSettings = ((LunarEvent)data.currentLunarEventHolder().comp_349()).getClientSettings().colorSettings();
            Vector3f lastGLColor = lastColorSettings.getGLMoonColor();
            Vector3f currentGLColor = currentColorSettings.getGLMoonColor();
            float blend = data.getBlend();
            float r = class_3532.method_37166((float)lastGLColor.x(), (float)currentGLColor.x(), (float)blend);
            float g = class_3532.method_37166((float)lastGLColor.y(), (float)currentGLColor.y(), (float)blend);
            float b = class_3532.method_37166((float)lastGLColor.z(), (float)currentGLColor.z(), (float)blend);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)(1.0f - level.method_8430(partialTicks)));
        });
    }

    public static void bindMoonTexture(int moonTextureId, class_2960 moonLocation) {
        class_638 level = class_310.method_1551().field_1687;
        Optional<EnhancedCelestialsLunarForecastWorldData> lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((class_1937)level);
        if (lunarForecastWorldData.isEmpty()) {
            RenderSystem.setShaderTexture((int)moonTextureId, (class_2960)moonLocation);
            return;
        }
        EnhancedCelestialsLunarForecastWorldData data = lunarForecastWorldData.orElseThrow();
        RenderSystem.setShaderTexture((int)moonTextureId, (class_2960)data.currentLunarEvent().getClientSettings().moonTextureLocation());
    }

    public static float getMoonSize(float arg0) {
        class_638 level = class_310.method_1551().field_1687;
        Optional<EnhancedCelestialsLunarForecastWorldData> lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((class_1937)level);
        if (lunarForecastWorldData.isEmpty()) {
            return arg0;
        }
        EnhancedCelestialsLunarForecastWorldData data = lunarForecastWorldData.orElseThrow();
        return class_3532.method_37166((float)data.lastLunarEvent().getClientSettings().moonSize(), (float)data.currentLunarEvent().getClientSettings().moonSize(), (float)data.getBlend());
    }

    public static void eventLightMap(Vector3f skyVector, float partialTicks) {
        class_638 level = class_310.method_1551().field_1687;
        EnhancedCelestials.lunarForecastWorldData((class_1937)level).ifPresent(data -> {
            LunarEvent lastEvent = data.lastLunarEvent();
            LunarEvent currentEvent = data.currentLunarEvent();
            ColorSettings colorSettings = currentEvent.getClientSettings().colorSettings();
            ColorSettings lastColorSettings = lastEvent.getClientSettings().colorSettings();
            Vector3f glSkyLightColor = lastColorSettings.getGLSkyLightColor();
            Vector3f targetColor = new Vector3f(glSkyLightColor.x(), glSkyLightColor.y(), glSkyLightColor.z());
            float skyDarken = (level.method_23783(1.0f) - 0.2f) / 0.8f;
            float eventBlend = data.getBlend() - skyDarken;
            targetColor.lerp((Vector3fc)colorSettings.getGLSkyLightColor(), eventBlend);
            float skyBlend = 1.0f - skyDarken - level.method_8430(partialTicks);
            skyVector.lerp((Vector3fc)targetColor, skyBlend);
        });
    }
}

