/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.dexrewards.datatypes;

import java.text.DecimalFormat;
import java.util.UUID;
import me.unariginal.dexrewards.DexRewards;
import me.unariginal.dexrewards.datatypes.PlayerData;
import me.unariginal.dexrewards.datatypes.rewards.RewardGroup;
import net.minecraft.class_3222;

public class Messages {
    public static String prefix = "<dark_gray>[<blue>DexRewards<dark_gray>]";
    public static String rewards_to_claim = "%prefix% You have rewards to claim!";
    public static String reward_claimable = "%prefix% You can claim the %group.name% rewards!";
    public static String rewards_claimed = "%prefix% You've claimed rewards for %group.name%!";
    public static String reset_sender = "%prefix% You've reset %player%'s pokedex reward progress!";
    public static String reset_target = "%prefix% Your pokedex reward progress has been reset!";
    public static String update_command = "%prefix% You've updated the pokedex reward progress of %player%";
    public static String reload = "%prefix% Reloaded!";

    public static String parse(String message) {
        message = message.replaceAll("%prefix%", prefix);
        message = message.replaceAll("%pokedex.total%", String.valueOf(DexRewards.DEX_TOTAL));
        return message;
    }

    public static String parse(String message, RewardGroup group) {
        message = Messages.parse(message);
        message = message.replaceAll("%group.name%", group.name);
        message = message.replaceAll("%group.percent%", String.valueOf(group.required_percent));
        return message;
    }

    public static String parse(String message, UUID player_uuid) {
        message = Messages.parse(message);
        class_3222 player = DexRewards.INSTANCE.server().method_3760().method_14602(player_uuid);
        if (player != null) {
            message = message.replaceAll("%player%", player.method_5820());
        }
        PlayerData player_data = null;
        for (PlayerData playerData : DexRewards.INSTANCE.config().player_data) {
            if (!playerData.uuid.equals(player_uuid)) continue;
            player_data = playerData;
            break;
        }
        if (player_data != null) {
            String rank = "None";
            for (RewardGroup group : DexRewards.INSTANCE.config().reward_groups) {
                if (!player_data.claimed_rewards.contains(group.name)) continue;
                rank = group.name;
            }
            message = message.replaceAll("%player.rank%", rank);
            message = message.replaceAll("%player.caught_count%", String.valueOf(player_data.caught_count));
            String string = new DecimalFormat("#.##").format((double)player_data.caught_count / (double)DexRewards.DEX_TOTAL * 100.0);
            message = message.replaceAll("%player.caught_percent%", string);
        }
        return message;
    }
}

