/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.dexrewards.config;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Species;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.unariginal.dexrewards.DexRewards;
import me.unariginal.dexrewards.datatypes.Messages;
import me.unariginal.dexrewards.datatypes.PlayerData;
import me.unariginal.dexrewards.datatypes.guielements.GuiElement;
import me.unariginal.dexrewards.datatypes.guielements.GuiLayout;
import me.unariginal.dexrewards.datatypes.rewards.CommandReward;
import me.unariginal.dexrewards.datatypes.rewards.ItemReward;
import me.unariginal.dexrewards.datatypes.rewards.Reward;
import me.unariginal.dexrewards.datatypes.rewards.RewardGroup;
import me.unariginal.dexrewards.utils.TextUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public class Config {
    public boolean implemented_only = true;
    public boolean allow_invalid_species = false;
    public List<Species> species_blacklist = new ArrayList<Species>();
    public List<String> label_blacklist = new ArrayList<String>();
    public List<String> generation_blacklist = new ArrayList<String>();
    public List<RewardGroup> reward_groups = new ArrayList<RewardGroup>();
    public List<PlayerData> player_data = new ArrayList<PlayerData>();
    public List<GuiElement> gui_elements = new ArrayList<GuiElement>();
    public GuiLayout gui_layout;

    public Config() {
        try {
            this.checkFiles();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.loadConfig();
        this.loadRewards();
        this.loadMessages();
        this.loadPlayerData();
    }

    private void checkFiles() throws IOException {
        String[] files;
        File main_file = FabricLoader.getInstance().getConfigDir().resolve("DexRewards").toFile();
        if (!main_file.exists()) {
            main_file.mkdirs();
        }
        for (String file : files = new String[]{"config.json", "messages.json", "rewards.json"}) {
            int len;
            File config_file = FabricLoader.getInstance().getConfigDir().resolve("DexRewards/" + file).toFile();
            if (!config_file.createNewFile()) continue;
            InputStream in = DexRewards.class.getResourceAsStream("/dr_config/" + file);
            FileOutputStream out = new FileOutputStream(config_file);
            assert (in != null);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
    }

    private JsonObject getRoot(File file) {
        JsonElement root_element;
        try {
            root_element = JsonParser.parseReader((Reader)new FileReader(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return root_element.getAsJsonObject();
    }

    private void loadConfig() {
        File config_file = FabricLoader.getInstance().getConfigDir().resolve("DexRewards/config.json").toFile();
        JsonObject root = this.getRoot(config_file);
        if (root == null) {
            return;
        }
        DexRewards.DEBUG = root.get("debug").getAsBoolean();
        this.implemented_only = root.get("implemented_only").getAsBoolean();
        this.allow_invalid_species = root.get("allow_invalid_species").getAsBoolean();
        JsonObject blacklist = root.get("blacklist").getAsJsonObject();
        JsonArray species_blacklist = blacklist.get("species").getAsJsonArray();
        for (JsonElement element : species_blacklist) {
            String species_id = element.getAsString();
            Species species = PokemonSpecies.INSTANCE.getByName(species_id);
            if (species == null) continue;
            this.species_blacklist.add(species);
        }
        this.label_blacklist = blacklist.get("label").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
        this.generation_blacklist = blacklist.get("generation").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
    }

    private void loadRewards() {
        File rewards_file = FabricLoader.getInstance().getConfigDir().resolve("DexRewards/rewards.json").toFile();
        JsonObject root = this.getRoot(rewards_file);
        if (root == null) {
            return;
        }
        JsonObject reward_groups = root.get("reward_groups").getAsJsonObject();
        ArrayList<RewardGroup> rewardGroups = new ArrayList<RewardGroup>();
        for (String key : reward_groups.keySet()) {
            JsonObject reward_group = reward_groups.get(key).getAsJsonObject();
            String icon_id = reward_group.get("icon").getAsString();
            class_1799 icon = ((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)icon_id))).method_7854();
            JsonElement icon_data = reward_group.get("icon_data");
            if (icon_data != null) {
                icon.method_59692((class_9326)((Pair)class_9326.field_49589.decode((DynamicOps)JsonOps.INSTANCE, (Object)icon_data).getOrThrow()).getFirst());
            }
            double required_percent = reward_group.get("required_caught_percent").getAsDouble();
            JsonObject rewards_object = reward_group.get("rewards").getAsJsonObject();
            ArrayList<Reward> rewards = new ArrayList<Reward>();
            for (String reward_key : rewards_object.keySet()) {
                JsonObject reward = rewards_object.get(reward_key).getAsJsonObject();
                String type = reward.get("type").getAsString();
                if (type.equalsIgnoreCase("item")) {
                    String item_id = reward.get("item").getAsString();
                    int count = reward.get("count").getAsInt();
                    class_1799 item = new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_60654((String)item_id)), count);
                    JsonElement item_data = reward.get("item_data");
                    if (item_data != null) {
                        item.method_59692((class_9326)((Pair)class_9326.field_49589.decode((DynamicOps)JsonOps.INSTANCE, (Object)item_data).getOrThrow()).getFirst());
                    }
                    rewards.add(new ItemReward(reward_key, type, item));
                    continue;
                }
                if (!type.equalsIgnoreCase("command")) continue;
                List<String> commands = reward.get("commands").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
                rewards.add(new CommandReward(reward_key, type, commands));
            }
            rewardGroups.add(new RewardGroup(key, icon, required_percent, rewards));
        }
        this.reward_groups = rewardGroups;
    }

    private void loadMessages() {
        String[] elements;
        File rewards_file = FabricLoader.getInstance().getConfigDir().resolve("DexRewards/messages.json").toFile();
        JsonObject root = this.getRoot(rewards_file);
        if (root == null) {
            return;
        }
        Messages.prefix = root.get("prefix").getAsString();
        JsonObject messages = root.get("messages").getAsJsonObject();
        Messages.rewards_to_claim = messages.get("rewards_to_claim").getAsString();
        Messages.reward_claimable = messages.get("reward_claimable").getAsString();
        Messages.rewards_claimed = messages.get("rewards_claimed").getAsString();
        Messages.update_command = messages.get("update_command").getAsString();
        Messages.reset_sender = messages.get("reset_command_sender").getAsString();
        Messages.reset_target = messages.get("reset_command_target").getAsString();
        Messages.reload = messages.get("reload_command").getAsString();
        JsonObject gui = root.get("gui").getAsJsonObject();
        String title = gui.get("title").getAsString();
        int size = gui.get("size").getAsInt();
        List<String> page_layout = gui.get("page_layout").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
        JsonObject page_layout_symbols = gui.get("page_layout_symbols").getAsJsonObject();
        String background_symbol = page_layout_symbols.get("background").getAsString();
        String player_info_symbol = page_layout_symbols.get("player_info").getAsString();
        String group_symbol = page_layout_symbols.get("group").getAsString();
        String previous_page_symbol = page_layout_symbols.get("previous_page").getAsString();
        String next_page_symbol = page_layout_symbols.get("next_page").getAsString();
        JsonObject background = gui.get("background").getAsJsonObject();
        String background_item_id = background.get("item").getAsString();
        String background_name = background.get("name").getAsString();
        List<String> background_lore = background.get("lore").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
        JsonElement background_item_data = background.get("item_data");
        class_1799 background_item = this.generateItem(background_item_id, background_name, background_lore, background_item_data);
        JsonObject navigation = gui.get("navigation").getAsJsonObject();
        String previous_item_id = navigation.get("previous_item").getAsString();
        String previous_name = navigation.get("previous_name").getAsString();
        List<String> previous_lore = navigation.get("previous_lore").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
        JsonElement previous_item_data = navigation.get("previous_item_data");
        class_1799 previous_item = this.generateItem(previous_item_id, previous_name, previous_lore, previous_item_data);
        String next_item_id = navigation.get("next_item").getAsString();
        String next_name = navigation.get("next_name").getAsString();
        List<String> next_lore = navigation.get("next_lore").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
        JsonElement next_item_data = navigation.get("next_item_data");
        class_1799 next_item = this.generateItem(next_item_id, next_name, next_lore, next_item_data);
        for (String element : elements = new String[]{"player_info", "claimed_group", "claimable_group", "locked_group"}) {
            JsonObject element_object = gui.get(element).getAsJsonObject();
            String name = element_object.get("name").getAsString();
            List<String> lore = element_object.get("lore").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList();
            boolean glint = element_object.get("show_enchantment_glint").getAsBoolean();
            this.gui_elements.add(new GuiElement(element, name, lore, glint));
        }
        this.gui_layout = new GuiLayout(title, size, page_layout, background_symbol, player_info_symbol, group_symbol, previous_page_symbol, next_page_symbol, background_item, previous_item, next_item);
    }

    private class_1799 generateItem(String id, String name, List<String> lore, JsonElement item_data) {
        class_1799 stack = ((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)id))).method_7854();
        ArrayList<class_2561> lore_text = new ArrayList<class_2561>();
        for (String line : lore) {
            lore_text.add(TextUtils.deserialize(line));
        }
        stack.method_57365(class_9323.method_57827().method_57840(class_9334.field_49631, (Object)TextUtils.deserialize(name)).method_57840(class_9334.field_49632, (Object)new class_9290(lore_text)).method_57838());
        if (item_data != null) {
            stack.method_59692((class_9326)((Pair)class_9326.field_49589.decode((DynamicOps)JsonOps.INSTANCE, (Object)item_data).getOrThrow()).getFirst());
        }
        return stack;
    }

    private void loadPlayerData() {
        File player_data_folder = FabricLoader.getInstance().getConfigDir().resolve("DexRewards/players").toFile();
        if (!player_data_folder.exists()) {
            player_data_folder.mkdirs();
        }
        for (File file : Objects.requireNonNull(player_data_folder.listFiles())) {
            JsonObject root;
            if (!file.getName().endsWith(".json") || (root = this.getRoot(file)) == null) continue;
            UUID uuid = UUID.fromString(root.get("uuid").getAsString());
            String username = root.get("username").getAsString();
            int caught_count = root.get("caught_count").getAsInt();
            JsonArray claimed = root.get("claimed_rewards").getAsJsonArray();
            ArrayList<String> claimed_rewards = new ArrayList<String>();
            for (JsonElement reward : claimed) {
                claimed_rewards.add(reward.getAsString());
            }
            JsonArray claimable = root.get("claimable_rewards").getAsJsonArray();
            ArrayList<String> claimable_rewards = new ArrayList<String>();
            for (JsonElement reward : claimable) {
                claimable_rewards.add(reward.getAsString());
            }
            this.player_data.add(new PlayerData(uuid, username, caught_count, claimed_rewards, claimable_rewards));
        }
    }

    public void updatePlayerData(PlayerData playerData) {
        try {
            File player_data_file = FabricLoader.getInstance().getConfigDir().resolve("DexRewards/players/" + playerData.uuid.toString() + ".json").toFile();
            player_data_file.createNewFile();
            JsonObject root = new JsonObject();
            root.addProperty("uuid", playerData.uuid.toString());
            root.addProperty("username", playerData.username);
            root.addProperty("caught_count", (Number)playerData.updateCaughtCount());
            JsonArray claimed_rewards = new JsonArray();
            for (String string : playerData.claimed_rewards) {
                claimed_rewards.add(string);
            }
            root.add("claimed_rewards", (JsonElement)claimed_rewards);
            JsonArray claimable_rewards = new JsonArray();
            for (String group : playerData.claimable_rewards) {
                claimable_rewards.add(group);
            }
            root.add("claimable_rewards", (JsonElement)claimable_rewards);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            FileWriter writer = new FileWriter(player_data_file);
            gson.toJson((JsonElement)root, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.player_data.removeIf(data -> data.uuid.equals(playerData.uuid));
        this.player_data.add(playerData);
    }

    public void generateImplementation(String id, String generation) {
        try {
            File implementation_file;
            File generation_folder;
            File generated_folder = FabricLoader.getInstance().getConfigDir().resolve("DexRewards/Generated").toFile();
            if (!generated_folder.exists()) {
                generated_folder.mkdirs();
            }
            if (!(generation_folder = FabricLoader.getInstance().getConfigDir().resolve("DexRewards/Generated/" + generation).toFile()).exists()) {
                generation_folder.mkdirs();
            }
            if ((implementation_file = FabricLoader.getInstance().getConfigDir().resolve("DexRewards/Generated/" + generation + "/" + id.replaceAll("cobblemon:", "") + ".json").toFile()).createNewFile()) {
                JsonObject root = new JsonObject();
                root.addProperty("target", id);
                root.addProperty("implemented", Boolean.valueOf(true));
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                FileWriter writer = new FileWriter(implementation_file);
                gson.toJson((JsonElement)root, (Appendable)writer);
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PlayerData getPlayerData(UUID uuid) {
        for (PlayerData data : this.player_data) {
            if (!data.uuid.equals(uuid)) continue;
            return data;
        }
        return null;
    }
}

