/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.dexrewards;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.pokedex.entry.DexEntries;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Species;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Unit;
import me.unariginal.dexrewards.commands.DexCommands;
import me.unariginal.dexrewards.config.Config;
import me.unariginal.dexrewards.datatypes.Messages;
import me.unariginal.dexrewards.datatypes.PlayerData;
import me.unariginal.dexrewards.datatypes.rewards.RewardGroup;
import me.unariginal.dexrewards.utils.TextUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DexRewards
implements ModInitializer {
    private static final String MODID = "dexrewards";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"dexrewards");
    public static DexRewards INSTANCE;
    public static boolean DEBUG;
    private FabricServerAudiences audience;
    private MinecraftServer server;
    private Config config;
    public static int DEX_TOTAL;
    public static List<class_2960> VALID_DEX_IDS;

    public void onInitialize() {
        INSTANCE = this;
        new DexCommands();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.audience = FabricServerAudiences.of((MinecraftServer)server);
            this.server = server;
            this.reload();
            Placeholders.register((class_2960)class_2960.method_60655((String)"pokedex", (String)"total"), (ctx, arg) -> PlaceholderResult.value((String)String.valueOf(DEX_TOTAL)));
            Placeholders.register((class_2960)class_2960.method_60655((String)"player", (String)"caught_count"), (ctx, arg) -> {
                if (!ctx.hasPlayer()) {
                    return PlaceholderResult.invalid((String)"No Player!");
                }
                class_3222 player = ctx.player();
                if (player != null) {
                    return PlaceholderResult.value((String)String.valueOf(this.config.getPlayerData((UUID)player.method_5667()).caught_count));
                }
                return PlaceholderResult.invalid((String)"No Player!");
            });
            Placeholders.register((class_2960)class_2960.method_60655((String)"player", (String)"rank"), (ctx, arg) -> {
                if (!ctx.hasPlayer()) {
                    return PlaceholderResult.invalid((String)"No Player!");
                }
                class_3222 player = ctx.player();
                if (player != null) {
                    PlayerData playerData = this.config.getPlayerData(player.method_5667());
                    if (playerData != null) {
                        String rank = "None";
                        for (RewardGroup group : DexRewards.INSTANCE.config().reward_groups) {
                            if (!playerData.claimed_rewards.contains(group.name)) continue;
                            rank = group.name;
                        }
                        return PlaceholderResult.value((String)rank);
                    }
                    return PlaceholderResult.invalid((String)"No Player Data!");
                }
                return PlaceholderResult.invalid((String)"No Player!");
            });
            Placeholders.register((class_2960)class_2960.method_60655((String)"player", (String)"caught_percent"), (ctx, arg) -> {
                if (!ctx.hasPlayer()) {
                    return PlaceholderResult.invalid((String)"No Player!");
                }
                class_3222 player = ctx.player();
                if (player != null) {
                    PlayerData playerData = this.config.getPlayerData(player.method_5667());
                    if (playerData != null) {
                        String percent = new DecimalFormat("#.##").format((double)playerData.caught_count / (double)DEX_TOTAL * 100.0);
                        return PlaceholderResult.value((String)percent);
                    }
                    return PlaceholderResult.invalid((String)"No Player Data!");
                }
                return PlaceholderResult.invalid((String)"No Player!");
            });
            Placeholders.register((class_2960)class_2960.method_60655((String)"pokedex", (String)"total_reward_groups"), (ctx, arg) -> PlaceholderResult.value((String)String.valueOf(this.config.reward_groups.size())));
        });
        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, packetSender, server) -> {
            class_3222 player = serverPlayNetworkHandler.method_32311();
            if (player != null) {
                PlayerData playerData = this.config.getPlayerData(player.method_5667());
                if (playerData == null) {
                    this.config.updatePlayerData(new PlayerData(player.method_5667(), player.method_5820(), 0, List.of(), List.of()));
                }
                if ((playerData = this.config.getPlayerData(player.method_5667())) != null) {
                    playerData.updateCaughtCount();
                    playerData.updateClaimableRewards();
                    if (!playerData.claimable_rewards.isEmpty()) {
                        player.method_43496(TextUtils.deserialize(Messages.parse(Messages.rewards_to_claim)));
                    }
                    this.config.updatePlayerData(playerData);
                }
            }
        });
        CobblemonEvents.POKEMON_GAINED.subscribe(Priority.HIGHEST, event -> {
            UUID player_uuid = event.getPlayerId();
            PlayerData playerData = this.config.getPlayerData(player_uuid);
            if (playerData != null) {
                playerData.updateCaughtCount();
                playerData.updateClaimableRewards();
            }
            return Unit.INSTANCE;
        });
    }

    public void reload() {
        this.config = new Config();
        int total = 0;
        int invalid_total = 0;
        int unimplemented_total = 0;
        ArrayList<class_2960> valid_identifiers = new ArrayList<class_2960>();
        for (Map.Entry entry : DexEntries.INSTANCE.getEntries().entrySet()) {
            Species species = PokemonSpecies.INSTANCE.getByIdentifier((class_2960)entry.getKey());
            if (species != null) {
                if (!this.config.implemented_only || species.getImplemented()) {
                    if (!this.config.species_blacklist.contains(species)) {
                        boolean valid = true;
                        for (String label : species.getLabels()) {
                            if (this.config.label_blacklist.contains(label)) {
                                valid = false;
                            }
                            if (!this.config.generation_blacklist.contains(label)) continue;
                            valid = false;
                        }
                        if (valid) {
                            ++total;
                            valid_identifiers.add((class_2960)entry.getKey());
                        } else {
                            ++invalid_total;
                        }
                    } else {
                        ++invalid_total;
                    }
                }
                if (species.getImplemented()) continue;
                ++unimplemented_total;
                continue;
            }
            if (this.config.allow_invalid_species) {
                ++total;
            }
            ++invalid_total;
        }
        DEX_TOTAL = total;
        this.logInfo("[DexRewards] Total Valid Pokedex Entries: " + DEX_TOTAL);
        this.logInfo("[DexRewards] Total Invalid Entries: " + invalid_total);
        this.logInfo("[DexRewards] Total Unimplemented: " + unimplemented_total);
        this.logInfo("[DexRewards] Total Pokedex Entries: " + (DEX_TOTAL + invalid_total + unimplemented_total));
        VALID_DEX_IDS = valid_identifiers;
        ArrayList<PlayerData> new_data = new ArrayList<PlayerData>(this.config().player_data);
        for (PlayerData data : new_data) {
            data.updateCaughtCount();
            data.updateClaimableRewards();
            this.config.updatePlayerData(data);
        }
    }

    public FabricServerAudiences audience() {
        return this.audience;
    }

    public MinecraftServer server() {
        return this.server;
    }

    public Config config() {
        return this.config;
    }

    public void logInfo(String message) {
        if (DEBUG) {
            LOGGER.info(message);
        }
    }

    static {
        DEBUG = false;
        DEX_TOTAL = DexEntries.INSTANCE.getEntries().size();
        VALID_DEX_IDS = new ArrayList<class_2960>();
    }
}

