/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;

public class DynamaxUtils {
    private static final Map<UUID, ScalingData> activeScalingAnimations = new HashMap<UUID, ScalingData>();
    private static final WeakHashMap<UUID, class_1309> entityCache = new WeakHashMap();
    public static MinecraftServer server;

    public static void startGradualScaling(class_1309 entity, float targetScale) {
        UUID entityId = entity.method_5667();
        class_1324 scaleAttribute = entity.method_5996(class_5134.field_47760);
        if (scaleAttribute != null) {
            entityCache.put(entityId, entity);
            float startScale = (float)scaleAttribute.method_6201();
            int durationTicks = 60;
            ScalingData scalingData = new ScalingData(entity.method_37908().method_27983().toString(), entityId, startScale, targetScale, durationTicks, 0);
            activeScalingAnimations.put(entityId, scalingData);
        }
    }

    public static void updateScalingAnimations(MinecraftServer server) {
        Iterator<Map.Entry<UUID, ScalingData>> iterator = activeScalingAnimations.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ScalingData> entry = iterator.next();
            UUID entityId = entry.getKey();
            ScalingData data = entry.getValue();
            ++data.currentTick;
            class_1309 entity = entityCache.get(entityId);
            if (entity == null || entity.method_31481()) {
                for (class_3218 world : server.method_3738()) {
                    entity = (class_1309)world.method_14190(entityId);
                    if (entity == null) continue;
                    entityCache.put(entityId, entity);
                    break;
                }
            }
            if (entity != null && !entity.method_31481()) {
                class_1324 scaleAttribute = entity.method_5996(class_5134.field_47760);
                if (scaleAttribute != null) {
                    float progress = Math.min(1.0f, (float)data.currentTick / (float)data.durationTicks);
                    float newScale = data.startScale + (data.targetScale - data.startScale) * progress;
                    scaleAttribute.method_6192((double)newScale);
                }
                if (data.currentTick < data.durationTicks) continue;
                iterator.remove();
                entityCache.remove(entityId);
                continue;
            }
            iterator.remove();
            entityCache.remove(entityId);
        }
    }

    private static class ScalingData {
        final String worldId;
        final UUID entityId;
        final float startScale;
        final float targetScale;
        final int durationTicks;
        int currentTick;

        public ScalingData(String worldId, UUID entityId, float startScale, float targetScale, int durationTicks, int currentTick) {
            this.worldId = worldId;
            this.entityId = entityId;
            this.startScale = startScale;
            this.targetScale = targetScale;
            this.durationTicks = durationTicks;
            this.currentTick = currentTick;
        }
    }
}

