/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class FileUtils {
    public static Path getSizePath() {
        return CobblemonSizeVariation.platform.getConfigDirectory().resolve("cobblemonsizevariation").resolve("sizes");
    }

    public static Path getSizeFile(String fileName) {
        return FileUtils.getSizePath().resolve(fileName);
    }

    public static JsonObject createFile(Gson gson, JsonObject content, Path file) {
        try {
            Files.createDirectories(Paths.get(file.toString(), new String[0]).getParent(), new FileAttribute[0]);
            FileWriter writer = new FileWriter(file.toString());
            gson.toJson((JsonElement)content, (Appendable)writer);
            writer.close();
            return content;
        }
        catch (IOException e) {
            CobblemonSizeVariation.LOGGER.error(String.format("Could not create size file: %s", file));
            return null;
        }
    }
}

